# Autostart based on Jet and tirboprop system for piston engines
#
# BARANGER Emmanuel (04/2024)

props.globals.initNode("/sim/autostart/started", 0, "BOOL");

var eng1fuelon  = func { setprop("/controls/engines/engine[0]/cutoff", 0); }
var eng2fuelon  = func { setprop("/controls/engines/engine[1]/cutoff", 0); }
var eng3fuelon  = func { setprop("/controls/engines/engine[2]/cutoff", 0); }
var eng4fuelon  = func { setprop("/controls/engines/engine[3]/cutoff", 0); }
var eng5fuelon  = func { setprop("/controls/engines/engine[4]/cutoff", 0); }
var eng6fuelon  = func { setprop("/controls/engines/engine[5]/cutoff", 0); }
var eng7fuelon  = func { setprop("/controls/engines/engine[6]/cutoff", 0); }
var eng8fuelon  = func { setprop("/controls/engines/engine[7]/cutoff", 0); }
var eng9fuelon  = func { setprop("/controls/engines/engine[8]/cutoff", 0); }
var eng10fuelon = func { setprop("/controls/engines/engine[9]/cutoff", 0); }
var eng11fuelon = func { setprop("/controls/engines/engine[10]/cutoff", 0); }
var eng12fuelon = func { setprop("/controls/engines/engine[11]/cutoff", 0); }

var eng1fueloff = func {
  setprop("/controls/engines/engine[0]/cutoff", 1);
  setprop("/controls/engines/engine[0]/throttle", 0);
}
var eng2fueloff = func {
  setprop("/controls/engines/engine[1]/cutoff", 1);
  setprop("/controls/engines/engine[1]/throttle", 0);
}
var eng3fueloff = func {
  setprop("/controls/engines/engine[2]/cutoff", 1);
  setprop("/controls/engines/engine[2]/throttle", 0);
}
var eng4fueloff = func {
  setprop("/controls/engines/engine[3]/cutoff", 1);
  setprop("/controls/engines/engine[3]/throttle", 0);
}
var eng5fueloff = func {
  setprop("/controls/engines/engine[4]/cutoff", 1);
  setprop("/controls/engines/engine[4]/throttle", 0);
}
var eng6fueloff = func {
  setprop("/controls/engines/engine[5]/cutoff", 1);
  setprop("/controls/engines/engine[5]/throttle", 0);
}
var eng7fueloff = func {
  setprop("/controls/engines/engine[6]/cutoff", 1);
  setprop("/controls/engines/engine[6]/throttle", 0);
}
var eng8fueloff = func {
  setprop("/controls/engines/engine[7]/cutoff", 1);
  setprop("/controls/engines/engine[7]/throttle", 0);
}
var eng9fueloff = func {
  setprop("/controls/engines/engine[8]/cutoff", 1);
  setprop("/controls/engines/engine[8]/throttle", 0);
}
var eng9fueloff = func {
  setprop("/controls/engines/engine[8]/cutoff", 1);
  setprop("/controls/engines/engine[8]/throttle", 0);
}
var eng10fueloff = func {
  setprop("/controls/engines/engine[9]/cutoff", 1);
  setprop("/controls/engines/engine[9]/throttle", 0);
}
var eng11fueloff = func {
  setprop("/controls/engines/engine[10]/cutoff", 1);
  setprop("/controls/engines/engine[10]/throttle", 0);
}
var eng12fueloff = func {
  setprop("/controls/engines/engine[11]/cutoff", 1);
  setprop("/controls/engines/engine[11]/throttle", 0);
}

var eng1starter  = func { setprop("/controls/engines/engine[0]/starter", 1); }
var eng2starter  = func { setprop("/controls/engines/engine[1]/starter", 1); }
var eng3starter  = func { setprop("/controls/engines/engine[2]/starter", 1); }
var eng4starter  = func { setprop("/controls/engines/engine[3]/starter", 1); }
var eng5starter  = func { setprop("/controls/engines/engine[4]/starter", 1); }
var eng6starter  = func { setprop("/controls/engines/engine[5]/starter", 1); }
var eng7starter  = func { setprop("/controls/engines/engine[6]/starter", 1); }
var eng8starter  = func { setprop("/controls/engines/engine[7]/starter", 1); }
var eng9starter  = func { setprop("/controls/engines/engine[8]/starter", 1); }
var eng10starter = func { setprop("/controls/engines/engine[9]/starter", 1); }
var eng11starter = func { setprop("/controls/engines/engine[10]/starter", 1); }
var eng12starter = func { setprop("/controls/engines/engine[11]/starter", 1); }

var eng1staroff  = func { setprop("/controls/engines/engine[0]/starter", 0); }
var eng2staroff  = func { setprop("/controls/engines/engine[1]/starter", 0); }
var eng3staroff  = func { setprop("/controls/engines/engine[2]/starter", 0); }
var eng4staroff  = func { setprop("/controls/engines/engine[3]/starter", 0); }
var eng5staroff  = func { setprop("/controls/engines/engine[4]/starter", 0); }
var eng6staroff  = func { setprop("/controls/engines/engine[5]/starter", 0); }
var eng7staroff  = func { setprop("/controls/engines/engine[6]/starter", 0); }
var eng8staroff  = func { setprop("/controls/engines/engine[7]/starter", 0); }
var eng9staroff  = func { setprop("/controls/engines/engine[8]/starter", 0); }
var eng10staroff = func { setprop("/controls/engines/engine[9]/starter", 0); }
var eng11staroff = func { setprop("/controls/engines/engine[10]/starter", 0); }
var eng12staroff = func { setprop("/controls/engines/engine[11]/starter", 0); }

var eng1start = func {
  gui.popupTip("*** Engine start 1 extreme left front  ***");
  eng1fueloff();
  eng1starter();
  settimer(eng1fuelon, 2);
  settimer(eng1staroff, 4);
}

var eng2start = func {
  gui.popupTip("*** Engine start 2 extreme right front  ***");
  eng2fueloff();
  eng2starter();
  settimer(eng2fuelon, 2);
  settimer(eng2staroff, 4);
}

var eng3start = func {
  gui.popupTip("*** Engine start 3 exterior left front  ***");
  eng3fueloff();
  eng3starter();
  settimer(eng3fuelon, 2);
  settimer(eng3staroff, 4);
}

var eng4start = func {
  gui.popupTip("*** Engine start 4 exterior right front  ***");
  eng4fueloff();
  eng4starter();
  settimer(eng4fuelon, 2);
  settimer(eng4staroff, 4);
}

var eng5start = func {
  gui.popupTip("*** Engine start 5 interior left front  ***");
  eng5fueloff();
  eng5starter();
  settimer(eng5fuelon, 2);
  settimer(eng5staroff, 4);
}

var eng6start = func {
  gui.popupTip("*** Engine start 6 interior right front  ***");
  eng6fueloff();
  eng6starter();
  settimer(eng6fuelon, 2);
  settimer(eng6staroff, 4);
}

var eng7start = func {
  gui.popupTip("*** Engine start 7 extreme left rear  ***");
  eng7fueloff();
  eng7starter();
  settimer(eng7fuelon, 2);
  settimer(eng7staroff, 4);
}

var eng8start = func {
  gui.popupTip("*** Engine start 8 extreme right rear ***");
  eng8fueloff();
  eng8starter();
  settimer(eng8fuelon, 2);
  settimer(eng8staroff, 4);
}

var eng9start = func {
  gui.popupTip("*** Engine start 9 exterior right rear ***");
  eng9fueloff();
  eng9starter();
  settimer(eng9fuelon, 2);
  settimer(eng9staroff, 4);
}

var eng10start = func {
  gui.popupTip("*** Engine start 10 exterior right rear ***");
  eng10fueloff();
  eng10starter();
  settimer(eng10fuelon, 2);
  settimer(eng10staroff, 4);
}

var eng11start = func {
  gui.popupTip("*** Engine start 11 interior left rear ***");
  eng11fueloff();
  eng11starter();
  settimer(eng11fuelon, 2);
  settimer(eng11staroff, 4);
}

var eng12start = func {
  gui.popupTip("*** Engine start 12 interior right rear ***");
  eng12fueloff();
  eng12starter();
  settimer(eng12fuelon, 2);
  settimer(eng12staroff, 4);
}

var engstart = func {
  settimer(eng1start,   2);
  settimer(eng2start,   6);
  settimer(eng3start,  10);
  settimer(eng4start,  14);
  settimer(eng5start,  18);
  settimer(eng6start,  22);
  settimer(eng7start,  26);
  settimer(eng8start,  30);
  settimer(eng9start,  34);
  settimer(eng10start, 38);
  settimer(eng11start, 42);
  settimer(eng12start, 46);
}

var engstop = func {
  settimer(eng1fueloff,   1);
  settimer(eng2fueloff,   2);
  settimer(eng3fueloff,   3);
  settimer(eng4fueloff,   4);
  settimer(eng5fueloff,   5);
  settimer(eng6fueloff,   6);
  settimer(eng7fueloff,   7);
  settimer(eng8fueloff,   8);
  settimer(eng9fueloff,   9);
  settimer(eng10fueloff, 10);
  settimer(eng11fueloff, 11);
  settimer(eng12fueloff, 12);
}

var autostart = func {
  var startstatus = getprop("/sim/autostart/started");
  if ( startstatus == 0 ) {
    gui.popupTip("Autostarting...");
    setprop("/sim/model/autostart", 1);
    setprop("/sim/autostart/started", 1);
    settimer(engstart, 0.4);
    gui.popupTip("Starting Engines");
  }
  if ( startstatus == 1 ) {
    gui.popupTip("Shutting Down...");
    setprop("/sim/model/autostart", 0);
    setprop("/sim/autostart/started", 0);
    engstop();
  }
}
