##################################################################
####      auxfuelwarn.nas - ePilot                            ####
####                                                          ####
####    Controls Aux Fuel Pump Warning Lights                 ####
####                                                          ####
##################################################################

var fuelwarn = func {

# set /controls/electric/auxfuelleft-warn and auxfuelright-warn appropriately
  elec_on    = getprop("systems/electrical/on");
  left_tran  = getprop("controls/fuel/internal/LTRAN");
  right_tran = getprop("controls/fuel/internal/RTRAN");
  left_flt_level=getprop("consumables/fuel/tank[2]/level-lbs");
  right_flt_level=getprop("consumables/fuel/tank[3]/level-lbs");
  left_drop_level=getprop("consumables/fuel/tank[4]/level-lbs");
  right_drop_level=getprop("consumables/fuel/tank[5]/level-lbs");

  if (elec_on) {
    if ((left_tran == 1 and left_drop_level < 5) or (left_tran == 2 and left_flt_level < 5)) {
      setprop("/controls/electric/auxfuelleft-warn", 1);
    } else {
      setprop("/controls/electric/auxfuelleft-warn", 0);
    }
    if ((right_tran == 1 and right_drop_level < 5) or (right_tran == 2 and right_flt_level < 5)) {
      setprop("/controls/electric/auxfuelright-warn", 1);
    } else {
      setprop("/controls/electric/auxfuelright-warn", 0);
    }

  } else {
    setprop("/controls/electric/auxfuelleft-warn",0);
    setprop("/controls/electric/auxfuelright-warn",0);
  }

settimer(fuelwarn, 2.3);
}

fuelwarn();

