##################################################################
####      copilot.nas - ePilot                                ####
####                                                          ####
####    CoPilot Announcements                                 ####
####                                                          ####
##################################################################


############################  Flaps  ##################################
var flappos = func {

# Report Flap Setting

  if (getprop("sim/co-pilot")) {

    var flapval= getprop("/controls/flight/flaps");

    if (flapval == 0) { var flapdeg="Up"; }
    if (flapval == 0.333333) { var flapdeg="15";  }
    if (flapval == 0.666666) { var flapdeg="30";  }
    if ((flapval == 0.999999) or (flapval == 1)) { var flapdeg="Full 40";  }

    setprop("/sim/messages/copilot", "Flaps " ~ flapdeg);
  }
}

setlistener("/controls/flight/flaps", flappos, 0, 0);

######################  Parking Brake  ################################
var parkingbrake = func {

if (getprop("sim/co-pilot")) {

# Check for parking brake on and confirm activated

  if (getprop("/controls/gear/brake-parking") == 1) {
     setprop("/sim/messages/copilot", "Parking Brake Engaged");
  }

# Check for parking brake off and confirm

  if (getprop("/controls/gear/brake-parking") == 0) {
    setprop("/sim/messages/copilot", "Parking Brake Off");
  }
}
}

setlistener("/controls/gear/brake-parking", parkingbrake, 0, 0);


######################  Gust Lock  ################################
var gustlock = func {

if (getprop("sim/co-pilot")) {

# Check for gustlock off and confirm

  if (getprop("controls/GustLock/lock-open") == 1) {
     setprop("/sim/messages/copilot", "Gust Lock Disengaged");
  }

# Check for parking brake off and confirm

  if (getprop("controls/GustLock/lock-open") == 0) {
    setprop("/sim/messages/copilot", "Gust Lock Engaged");
  }
}
}

setlistener("controls/GustLock/lock-open", gustlock, 0, 0);



###############################  Reverse Left  #############################
var reverseleft = func {

if (getprop("sim/co-pilot")) {

# Check for reverser on and confirm activated

  if (getprop("/controls/engines/engine[0]/reverser") == 1) {
     setprop("/sim/messages/copilot", "Left Reverser Control Activated");
  }

# Check for reverser off and confirm

  if (getprop("/controls/engines/engine[0]/reverser") == 0) {
    setprop("/sim/messages/copilot", "Left Reverser Off");
  }
}
}

setlistener("/controls/engines/engine[0]/reverser", reverseleft, 0, 0);

###############################  Reverse Right  #############################
var reverseright = func {

if (getprop("sim/co-pilot")) {

# Check for reverser on and confirm activated

  if (getprop("/controls/engines/engine[1]/reverser") == 1) {
     setprop("/sim/messages/copilot", "Right Reverser Control Activated");
  }

# Check for reverser off and confirm

  if (getprop("/controls/engines/engine[1]/reverser") == 0) {
    setprop("/sim/messages/copilot", "Right Reverser Off");
  }
}
}

setlistener("/controls/engines/engine[1]/reverser", reverseright, 0, 0);

###################################    Gear Up/Down    #############################

var gearpos = func {

if (getprop("sim/co-pilot")) {

# Check for gear retraction and confirm gear up

  if (getprop("/gear/gear/position-norm") == 0) {
     setprop("/sim/messages/copilot", "Confirmed - Gear Up");
  }

# Check for gear extension and confirm - then advise landing speed

  if (getprop("/gear/gear/position-norm") == 1) {
     setprop("/sim/messages/copilot", "Gear Down");

# Calculate Recommended Landing Speeds

  var grossweight = getprop("fdm/jsbsim/inertia/weight-lbs") or 0.00;
   var RLS = 0;
   if (grossweight < 77000) {
     RLS = 111;
   } elsif ((grossweight >77000) and (grossweight <88000)) {
     RLS = 119;
   } elsif ((grossweight >88000) and (grossweight <99000)) {
     RLS = 127;
   } elsif ((grossweight >99000) and (grossweight <110000)) {
     RLS = 134;
   } elsif ((grossweight >110000) and (grossweight <121000)) {
     RLS = 141;
   } elsif ((grossweight >121000) and (grossweight <132000)) {
     RLS = 147;
   } elsif (grossweight >132000) {
     RLS = 153;
   }
#   setprop("/sim/messages/copilot", "Gross Weight " ~ grossweight ~" - Recommend " ~ RLS ~ " Kt Touchdown @ Flaps 30");
  }

}
}

setlistener("/gear/gear/position-norm", gearpos, 0, 0);

##################################   V-Speeds Callout   ###########################

setlistener("/sim/signals/fdm-initialized", func {
    copilot.init();
});

# var V1 = props.globals.initNode("/instrumentation/fmc/vspeeds/V1",140,"DOUBLE");
# var V2 = props.globals.initNode("/instrumentation/fmc/vspeeds/V2",150,"DOUBLE");
# var VR = props.globals.initNode("/instrumentation/fmc/vspeeds/VR",170,"DOUBLE");


# Copilot V-Speed announcements

var copilot = {
  init : func {
        me.UPDATE_INTERVAL = 1.73;
        me.loopid = 0;
    # Initialize state variables.
    me.Fortyannounced = 0;
    me.V1announced = 0;
    me.VRannounced = 0;
    me.V2announced = 0;
    me.PRannounced = 0;
        me.reset();
        print("Copilot ready");
    },
  update : func {

# Calculate V Speeds

var grossweight = getprop("fdm/jsbsim/inertia/weight-lbs") or 0.00;
var V1 = 0;
var VR = 0;
var V2 = 0;
if (grossweight < 24000) {
   V1 = 90;
   VR = 94;
   V2 = 98;
   } elsif ((grossweight >24000) and (grossweight <25500)) {
   V1 = 94;
   VR = 98;
   V2 = 102;
   } elsif ((grossweight >25500) and (grossweight <28000)) {
   V1 = 98;
   VR = 102;
   V2 = 106;
   } elsif (grossweight >28000) {
   V1 = 102;
   VR = 106;
   V2 = 110;
   }

    setprop("/instrumentation/fmc/vspeeds/V1", V1);
    setprop("/instrumentation/fmc/vspeeds/VR", VR);
    setprop("/instrumentation/fmc/vspeeds/V2", V2);

    var airspeed = getprop("velocities/airspeed-kt");
    var V1 = getprop("/instrumentation/fmc/vspeeds/V1");
    var VR = getprop("/instrumentation/fmc/vspeeds/VR");
    var V2 = getprop("/instrumentation/fmc/vspeeds/V2");

        if ((airspeed > 39) and (me.Fortyannounced == 0)) {
            me.announce("40 Knots");
      me.Fortyannounced = 1;
        } elsif ((airspeed != nil) and (V1 != nil) and (airspeed > V1) and (me.V1announced == 0)) {
            me.announce("V1");
      me.V1announced = 1;
        } elsif ((airspeed != nil) and (VR != nil) and (airspeed > VR) and (me.VRannounced == 0)) {
            me.announce("Rotate");
      me.VRannounced = 1;
        } elsif ((airspeed != nil) and (V2 != nil) and (airspeed > V2) and (me.V2announced == 0)) {
            me.announce("V2");
      me.V2announced = 1;
        } elsif ((V1 == nil) or (V2 == nil) or (VR == nil)){
      print ("FMU Toast - Vspeeds not calculated");
    }

    },
  announce : func(msg) {
      if (getprop("sim/co-pilot")) {
        setprop("/sim/messages/copilot", msg);
      }
    },
    reset : func {
        me.loopid += 1;
        me._loop_(me.loopid);
    },
    _loop_ : func(id) {
        id == me.loopid or return;
        me.update();
        settimer(func { me._loop_(id); }, me.UPDATE_INTERVAL);
    }
};

